
<?php $__env->startSection('title'); ?>
    <title><?php echo e($content->meta_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <meta name="description" content="<?php echo e($content->meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <meta name="keywords" content="<?php echo e($content->meta_keywords); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-contents'); ?>
    
    <section class="breadcrum" style="background-image: url(<?php echo e(asset("storage/$content->banner")); ?>); ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1><?php echo e($content->title); ?></h1>
                </div>
            </div>
        </div>
    </section>

    <section class="vacation-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 content">
                    <div class="row">

                        <div class="col-lg-5 col-md-12 col-sm-12 my-auto">
                            <img src=<?php echo e(asset("storage/$content->image")); ?> class="img-fluid" alt="">
                        </div>
                        <div class="col-lg-7 col-md-12 col-sm-12 content-heading my-auto">
                            <h1><?php echo e($content->image_title); ?></h1>

                            <div><?php echo $content->description; ?>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="vacation-tab-section">
        <div class="vacation-tab1">
            <div class="col-lg-6 col-md-7 col-sm-12 mx-auto">
                <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist">

                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a class="button_1" id="<?php echo e($detail->id); ?>" style="text-decoration: none"><button class="nav-link">
                                <?php echo e($detail->port_name); ?>

                            </button></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>
        <div class="tab-content " id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="testing" tabindex="0">

                <div class="container mt-5 tab-cont shadow">


                    <div id="ports"></div>
                </div>
            </div>


        </div>
    </section>

    <section class="book-view">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 my-auto">
                    <h2 class="text-white">Discover, explore, and book your next adventure with us today !</h2>
                </div>
                <div class="col-lg-4 my-auto ms-auto">
                    <a href="<?php echo e(route('booking-forms', ['page_name' => $content->title])); ?>" class="text-decoration-none">
                        <button class="book-now">
                            <span class="text">Book with us</span>
                            <span class="icon"><svg aria-hidden="true" width="20px" data-icon="paper-plane"
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path fill="currentColor"
                                        d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z">
                                    </path>
                                </svg></span>
                        </button>
                    </a>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function() {
            getContents($('.button_1').attr('id'))
        });

        $(".button_1").click(function(e) {
            $("#ports").empty();
            var $this = $(this);
            var id = $this.attr("id");
            // alert(id);
            e.preventDefault();
            getContents(id)
            return false;
        });

        function getContents(id) {
            $.ajax({
                type: "GET",
                url: '<?php echo e(route('ports')); ?>',
                data: {
                    id
                },
                dataType: "json",
                success: function(answer) {
                    console.log('answer', answer);
                    for (var i = 0; i < answer.length; i++) {

                        var image = answer[i].image;
                        var port_location_name = answer[i].port_location_name;
                        var description = answer[i].description;

                        var htm = `<div class="col-lg-12 col-md-12 col-sm-12 mt-5">
                        <div class="row">
                            <div class="col-lg-4 text-center mx-auto">
                                <img src="<?php echo e(asset('storage/${image}')); ?>" class="img-fluid" alt="">
                            </div>

                            <div class="col-lg-6 mx-auto my-auto">
                                <h2>${port_location_name}</h2>
                                <p>
                                    ${description}
                                </p>
                            </div>

                        </div>
                    </div>`;
                        $("#ports").append(htm);
                    }
                },
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('Frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Frontend/Pages/Cruises/top_cruise_ports.blade.php ENDPATH**/ ?>