

<?php $__env->startSection('title'); ?>
    <title><?php echo e($locationdetail->meta_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <meta name="description" content="<?php echo e($locationdetail->meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <meta name="keywords" content="<?php echo e($locationdetail->meta_keywords); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-contents'); ?>
    <?php $__env->startPush('styles'); ?>
        <style>
            #map1 {
                height: 500px;
                /* The height is 400 pixels */
                width: 100%;
                /* The width is the width of the web page */
            }

            .breadcrum1 {
                height: 80px;
                background-color: #063A72;
            }

            .profile-card {
                letter-spacing: 0.025em;
                text-align: center;
                color: #002D40;
                margin-bottom: 40px;
                /* position: relative; */
            }

            .profile-card .pic {
                height: 100%;
                width: 100%;
                /* margin: -100px auto 0 auto; */
                /* border-radius: 50%; */
                overflow: hidden;
                z-index: 2;
            }

            .profile-card a {
                text-decoration: none;
            }

            .profile-card .pic img {
                height: 100%;
                width: 100%;
                object-fit: cover;
                border-radius: 2rem 0 0 2rem;

            }

            .profile-card .profile {
                /* position: relative; */
                background: white;
                width: 100%;
                border-radius: 2rem;
                /* padding: 2rem 0; */
                box-sizing: border-box;
                transition: transform 500ms ease-in-out;
                box-shadow: 0 2px 4px -3px rgba(0, 45, 64, 0.085), 0 0rem 8px 0 rgba(0, 45, 64, 0.1);
            }

            .profile-card .above-fold {
                padding: 22px 0;
            }

            .profile-card .above-fold .name {
                font-size: 25px;
                font-weight: 500;
                margin-bottom: 0.4rem;
            }

            .profile-card .above-fold .role {
                font-size: 16px;
                font-weight: 400;
                color: #000;
                /* margin-bottom: 0.8rem; */
            }

            .profile-card .above-fold .location {
                font-size: 16px;
                margin: 10px 0;
                color: #000;
                font-weight: 600;
            }

            .profile-card .above-fold .location i {
                margin-right: 10px;
            }

            .profile-card.expand .cover {
                opacity: 1;
                transform: translateY(-5rem);
                transition: transform 500ms ease-in-out, opacity 200ms 0ms;
            }

            .profile-card.expand .profile {
                transform: translateY(5rem);
            }

            .profile-card.expand .below-fold {
                max-height: 19em;
                opacity: 1;
            }

            .profile-card.expand #expand-button {
                animation: none;
                transform: rotate(180deg);
            }



            .profile-card .button {
                padding: 1.2rem;
                width: 70%;
                margin: 30px auto 0px auto;
                /* margin: 1rem 0.5rem 0; */
                box-sizing: border-box;
                background: transparent;
                cursor: pointer;
                font-size: 18px;
                line-height: 0;
                font-weight: 500;
                color: #014B9A;
                border: 1px solid#014B9A;
                border-radius: 2rem;
                transition: background 200ms, color 200ms;
            }

            .profile-card .button:hover {
                background: #014B9A;
                color: white;
            }

            .agency-form {
                background-color: #f1f1f1;
                padding: 30px;
                border-radius: 6px;
            }

            .agency-form label {
                font-size: 15px;
                margin-top: 15px;
                padding-bottom: 4px;

            }

            .agency-form input {
                height: 40px;
                width: 100%;
                padding-left: 10px;
                border: none;
                outline: none;
                font-size: 14px;
            }

            .agency-form textarea {
                width: 100%;
                padding: 10px;
                border: none;
                outline: none;
                font-size: 14px;
            }

            .agency-btn {
                width: 100%;
                padding: 12px 30px;
                background-color: #014B9A;
                border: none;
                outline: none;
                color: #fff;
                border-radius: 5px;
                margin-top: 20px;
            }

            .agent-sec {
                height: 100%;
                width: 100%;
                box-shadow: 1px 0px 15px #00000021;
                background-color: #094780
            }

            .agent-image {
                height: 100%;
                min-height: 280px
            }

            .agent-image img {
                height: 100%;
                width: 100%;
                object-fit: cover;
            }

            .agent-info {
                padding-top: 30px;
                padding-bottom: 15px;
                padding-right: 20px
            }

            .agent-info h2 {
                font-size: 22px;
                font-weight: 500;
                line-height: 1.3px;
                color: #fff;
                margin-bottom: 20px;
                text-transform: uppercase;
            }

            .agent-info a {
                text-decoration: none;
                font-size: 14px;
                color: #fff;
                word-break: break-all
            }

            .agent-info p {
                color: #fff;
                word-break: break-all
            }


            .agent-info .button {
                padding: 15px;
                width: 85%;
                margin: 10px 0 0px 0;
                /* margin: 1rem 0.5rem 0; */
                box-sizing: border-box;
                background: transparent;
                cursor: pointer;
                font-size: 16px;
                line-height: 0;
                text-align: center;
                font-weight: 500;
                color: #fff;
                border: 1px solid#014B9A;
                border-radius: 2rem;
                transition: .4s all;
            }

            .agent-info .button:hover {
                background-color: #014B9A;
                color: #014B9A;
            }

            @media only screen and (max-width: 600px) {
                .agent-info {
                    padding: 29px 30px;
                }
            }


            /* profile card css */
            .profile-card1 {
                width: 100%;
                border-radius: 0.7rem;
                border: 1px solid #014B9A;
            }

            .cover img {
                height: 10%;
                border-top-left-radius: 0.7rem;
                border-top-right-radius: 0.7rem;
            }

            .profile img {
                width: 130px;
                height: 130px;
                border-radius: 100%;
                border: 2px solid #fff;
                margin-top: -100px;
                margin-left: 20px;
            }

            .req-btn {
                height: 35px;
                width: auto;
                padding: 8px 20px;
                background: #014B9A;
                color: #fff;
                font-size: 14px;
                border-radius: 20px;
                margin-left: 55%;
                text-decoration: none;
            }

            .req-btn:hover {
                background: #181818;
                cursor: pointer;
                border: None;
                color: #fff;
            }

            .profile1-cont {
                padding: 20px 20px 10px 20px;
            }

            .profile1-cont h3 {
                font-size: 20px;
                text-transform: uppercase;
                margin-bottom: 25px;
            }

            .profile1-cont p {
                font-size: 15px;
                color: #000;
                line-height: 1.3;
                margin-top: -10px;
                font-weight: 500;

            }

            .profile1-cont a {
                text-decoration: none;
            }
        </style>
    <?php $__env->stopPush(); ?>
    <section class="locations-area">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="breadcrum1">

                    </div>
                    <div id="map1">
                        <iframe src="<?php echo e($locationdetail->map_link); ?>" width="100%" height="100%" style="border:0;"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="add-info">
        <div class="container">
            <div class="row">
                <div class="contact-wrapper col-md-12">
                    <div class="row">
                        <div class="col-md-3 contact-item">
                            <div class="icon">
                                <i class="fal fa-map-marker-alt"></i>
                            </div>
                            <div class="content">
                                <h6 class="color2">Location</h6>
                                <p class="color2"><b><?php echo e($locationdetail->title); ?></b><br><?php echo $locationdetail->address; ?>

                                </p>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="contact-item">
                                <div class="icon">
                                    <i class="fal fa-calendar-check"></i>
                                </div>
                                <div class="content">
                                    <h6 class="color2">Office Hours</h6>

                                    <?php echo $locationdetail->timings; ?>


                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 ">
                            <div class="contact-item">
                                <div class="icon">
                                    <i class="fal fa-phone-volume"></i>
                                </div>
                                <div class="content">
                                    <h6 class="color2">Phone Number</h6>
                                    <a href="tel:<?php echo e($locationdetail->phone); ?>"><?php echo e($locationdetail->phone); ?></a>
                                </div>
                            </div>
                            <div class="contact-item" style="margin-top: -30px;">
                                <div class="icon">
                                    <i class="fal fa-envelope"></i>
                                </div>
                                <div class="content">
                                    <h6 class="color2">Email Address</h6>
                                    <a href="<?php echo e('mailto:' . $locationdetail->email); ?>"><?php echo e($locationdetail->email); ?></a>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if(session()->has('message')): ?>
        <div class="alert alert-success" style="text-align: center">
            <?php echo e(session()->get('message')); ?>

        </div>
    <?php endif; ?>

    <section class="agent mt-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="row m-0">
                    <div class="col-lg-8">
                        <div class="row">
                            <?php
                                $travel_professionals = \App\Models\TravelProfessional::where(
                                    'location_id',
                                    $locationdetail->id,
                                )
                                    ->where('status', 1)
                                    ->get();
                            ?>
                            <?php $__currentLoopData = $travel_professionals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $travel_professional): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-6 mb-4">
                                    <div class="profile-card1">
                                        <div class="cover">
                                            <img src="https://testwebsites.ca/gill-international/public/storage/Home/new_letter_image/9owLJu7zHMPVkquFYeu8ycEREY1hLKQWGDtyUeO6.jpg"
                                                class="img-fluid" alt="">
                                        </div>
                                        <?php if($travel_professional->no_quote_request != 1): ?>
                                            <a href="<?php echo e(route('booking-forms', ['page_name' => $locationdetail->title, 'traveller' => $travel_professional->id, 'location' => $locationdetail->id])); ?>"
                                                class="req-btn"> Quote Request </a>
                                        <?php endif; ?>
                                        <div class="profile">
                                            <img src="<?php echo e(asset("storage/$travel_professional->image")); ?>" alt="Profile">

                                        </div>

                                        <div class="profile1-cont">
                                            <h3><?php echo e($travel_professional->name); ?></h3>
                                            <p>
                                                Email: <a
                                                    href="mailto:<?php echo e($travel_professional->email); ?>"><?php echo e($travel_professional->email); ?></a>
                                            </p>
                                            <p>
                                                Location: <?php echo e($travel_professional->location); ?>

                                            </p>
                                            <p>
                                                Profession: <?php echo e($travel_professional->profession); ?>

                                            </p>
                                        </div>



                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="agency-form">
                            <div class="row">
                                <div class="col-lg-12 d-flex text-primary">
                                    <i class="far fa-comment-alt-lines mt-1 me-2"></i>
                                    <p style="font-size: 16px; font-weight: 500;"> Contact Agency</p>
                                </div>

                                <div class="col-lg-12 p-3 border">
                                    <div class="row">
                                        <form action="<?php echo e(route('contact-agency')); ?>" method="POST">
                                            <div class="form-group" style="display: none;">
                                                <label for="faxonly">Fax Only
                                                    <input type="checkbox" name="faxonly" id="faxonly" />
                                                </label>
                                            </div>
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="store_email"
                                                value="<?php echo e($travel_professional->email); ?>">
                                            <input type="hidden" name="location_id" id="location_id"
                                                value="<?php echo e($locationdetail->id); ?>">
                                            <input type="hidden" name="contact_us_email" id="contact_us_email"
                                                value="<?php echo e($locationdetail->email); ?>">
                                            <div class="col-lg-12">
                                                <label for="First Name">Full Name</label>
                                                <input type="text" name="name" id="name" required oninput="validateInput(this)">
                                            </div>
                                            
                                            <div class="col-lg-12">
                                                <label for="">Email Address</label>
                                                <input type="text" name="email" id="email_address" required>
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="">Phone Number</label>
                                                <input type="text" name="phone_number" id="phone_number" required onkeypress="return onlyNumberKey(event)" maxlength="15" minlength="10">
                                            </div>
                                            <div class="col-lg-12">
                                                <label for="">Message</label>
                                                <textarea name="message" id="message" rows="3" required oninput="validateInput(this)"></textarea>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="g-recaptcha mb-2" data-sitekey="6LehSssqAAAAAE1CPQLjLoZY7dnh4UycWmweSUlt" data-callback="correctCaptcha"></div>
                                            </div>
                                            <div class="col-lg-12">
                                                <button class="agency-btn" disabled id="submitButton">Send Message</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <script>
        function validateInput(input) {
            // Remove special characters except letters and spaces
            input.value = input.value.replace(/[^a-zA-Z\s]/g, '');
        }
        function onlyNumberKey(evt) {
            var ASCIICode = (evt.which) ? evt.which : evt.keyCode
            if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
                return false;
            return true;
        }
        function correctCaptcha() {
            $('#submitButton').attr('disabled', false);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Frontend/Pages/Locations/location-detail.blade.php ENDPATH**/ ?>