

<?php $__env->startSection('title'); ?>
    <title><?php echo e($wedding->meta_title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_description'); ?>
    <meta name="description" content="<?php echo e($wedding->meta_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('meta_keywords'); ?>
    <meta name="keywords" content="<?php echo e($wedding->meta_keywords); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-contents'); ?>
    <section class="breadcrum"
        style="background-image: url(<?php echo e(asset("storage/$wedding->banner")); ?>); background-position: top center; ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1><?php echo e($wedding->title); ?></h1>
                </div>
            </div>
        </div>
    </section>


    <section class="book-view">
        <div class="container">
            <div class="row">

                <div class="col-lg-6 my-auto">
                    <h2 class="text-white">Discover, explore, and book your next adventure with us today !</h2>
                </div>
                <div class="col-lg-4 my-auto ms-auto">
                   <a href="<?php echo e(route('wedding.booking')); ?>" class="text-decoration-none">
                        <button class="book-now">
                            <span class="text">Book with us</span>
                            <span class="icon"><svg aria-hidden="true" width="20px" data-icon="paper-plane" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z"></path></svg></span>
                        </button>
                   </a>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb wedding-sec">
        <div class="container">
            <div class="row">

                <div class="mb-5">
                    <a href=<?php echo e(route('index')); ?> class="back-button">Back to home <i class="fa fa-arrow-left"></i></a>
                </div>

                <div class="col-lg-6 col-md-6 col-sm-12 ">
                    <div class="wedding-cont">
                        <h3 class="mb-4"><?php echo e($wedding->destination_wedding_title); ?></h3>
                        <p>
                            <?php echo $wedding->destination_wedding_description; ?>

                        </p>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->destination_wedding_image")); ?>" class="img-fluid rounded"
                            alt="">
                    </div>
                </div>
            </div>
            <div class="row mt-5">
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->destination_wedding_form_image")); ?>" class="img-fluid rounded"
                            alt="">
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="wedding-cont" style="text-align: left;">
                        <div class="row">
                            <div class="col-lg-10 col-md-10 col-sm-12">
                                <h3 class="mb-4"><?php echo e($wedding->destination_wedding_form_title); ?></h3>
                                <p>
                                    <?php echo $wedding->destination_wedding_form_description; ?>

                                </p>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="vacation-section Planning">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 content">
                    <div class="row">
                        <div class="col-lg-5 col-md-12 col-sm-12">
                            <img src="<?php echo e(asset("storage/$wedding->destination_wedding_plan_image")); ?>" class="img-fluid"
                                alt="">
                        </div>
                        <div class="col-lg-7 col-md-12 col-sm-12 content-heading my-auto">
                            <h1 class="planning-title"> <?php echo e($wedding->destination_wedding_plan_title); ?></span></h1>
                            <p>
                                <?php echo $wedding->destination_wedding_plan_description; ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb">
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12 col-12">
                    <h2 style="color: #337d9d;"> Get Ahead and Plan Early </h2>
                </div>
                <div class="col-lg-6">
                    <p>
                        Planning ahead is the best way to go for any wedding, but it’s even more important when planning
                        a destination wedding. Gill Travel recommends following these 6 crucial steps to cover the basis
                        of your destination wedding.
                    </p>
                </div>

                <div class="col-lg-9 col-md-12 mx-auto ptb col-sm-12">
                    <div class="main-timeline">
                        <div class="timeline">
                            <div class="timeline-content">
                                <div class="circle">
                                    <span class="homebox">
                                        <img src="<?php echo e(asset('Frontend/img/wedding/step1.jpg')); ?>" class="img">
                                    </span>
                                </div>
                                <div class="content">
                                    <span class="year">Step 1 </span>
                                    <h3 class="title h4">Choose your Gill Travel Wedding Consultant</h3>
                                    <div class="icon"><span></span></div>
                                </div>
                            </div>
                        </div>
                        <div class="timeline">
                            <div class="timeline-content">
                                <div class="circle"><span class="homebox"><img src="<?php echo e(asset('Frontend/img/wedding/step2.jpg')); ?>"
                                            class="img" /></span></div>
                                <div class="content">
                                    <span class="year">Step 2</span>
                                    <h3 class="title h4"> Select an overall Wedding Theme</h3>
                                    <div class="icon"><span></span></div>
                                </div>
                            </div>
                        </div>
                        <div class="timeline">
                            <div class="timeline-content">
                                <div class="circle"><span class="homebox"><img
                                            src="<?php echo e(asset('Frontend/img/wedding/step3.jpg')); ?>" class="img"></span></div>
                                <div class="content">
                                    <span class="year">Step 3</span>
                                    <h3 class="title h4"> Pick your Destination, Travel and Hotel </h3>
                                    <div class="icon"><span></span></div>
                                </div>
                            </div>
                        </div>
                        <div class="timeline">
                            <div class="timeline-content">
                                <div class="circle"><span class="homebox"><img src="<?php echo e(asset('Frontend/img/wedding/step4.jpg')); ?>"
                                            class="img"></span></div>
                                <div class="content">
                                    <span class="year">Step 4</span>
                                    <h3 class="title h4">Pick a Wedding Date </h3>

                                    <div class="icon"><span></span></div>
                                </div>
                            </div>
                        </div>
                        <div class="timeline">
                            <div class="timeline-content">
                                <div class="circle"><span class="homebox"><img
                                            src="<?php echo e(asset('Frontend/img/wedding/step5.jpg')); ?>" class="img"></span></div>
                                <div class="content">
                                    <span class="year">Step 5</span>
                                    <h3 class="title 4">Get the Destination’s Legal Requirements</h3>

                                    <div class="icon"><span></span></div>
                                </div>
                            </div>
                        </div>
                        <div class="timeline">
                            <div class="timeline-content">
                                <div class="circle"><span class="homebox"><img
                                            src="<?php echo e(asset('Frontend/img/wedding/step6.jpg')); ?>" class="img"></span></div>
                                <div class="content">
                                    <span class="year">Step 6</span>
                                    <h3 class="title h4">Complete your Reservation !</h3>

                                    <div class="icon"><span></span></div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="planning-bg" style="background-image: url(<?php echo e(asset("storage/$wedding->about_image")); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto col-md-12 col-sm-12">
                    <p>
                        <?php echo $wedding->about_description; ?>

                    </p>
                </div>
            </div>
        </div>
    </section>


    <section class="ptb wedding-sec">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-6 col-sm-12 ">
                    <div class="wedding-cont">
                        <h3 class="mb-4"><?php echo e($wedding->gift_registry_title); ?></h3>
                        <p>
                            <?php echo $wedding->gift_registry_description; ?>

                        </p>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->gift_registry_image")); ?>" class="img-fluid rounded" alt="">
                    </div>
                </div>
            </div>
            <div class="row justify-content-center mt-5">
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->easy_registration_image")); ?>" class="img-fluid rounded" alt="">
                    </div>
                </div>
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-cont" style="text-align: left;">
                        <div class="row">
                            <div class="col-lg-10 col-md-10 col-sm-12">
                                <h3 class="mb-4"><?php echo e($wedding->easy_registration_title); ?></h3>
                                <p>
                                    <?php echo $wedding->easy_registration_description; ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center mt-5">
                <div class="col-lg-5 col-md-6 col-sm-12 ">
                    <div class="wedding-cont">
                        <h3 class="mb-4"><?php echo e($wedding->buying_process_title); ?></h3>
                        <p>
                            <?php echo $wedding->buying_process_description; ?>

                        </p>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->buying_process_image")); ?>" class="img-fluid rounded" alt="">
                    </div>
                </div>
            </div>
            <div class="row justify-content-center mt-5">
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->gift_card_image")); ?>" class="img-fluid rounded"
                            alt="">
                    </div>
                </div>
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-cont" style="text-align: left;">
                        <div class="row">
                            <div class="col-lg-10 col-md-10 col-sm-12">
                                <h3 class="mb-4"><?php echo e($wedding->gift_card_title); ?> </h3>
                                <p>
                                    <?php echo $wedding->gift_card_description; ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center mt-5">
                <div class="col-lg-5 col-md-6 col-sm-12 ">
                    <div class="wedding-cont">
                        <h3 class="mb-4"><?php echo e($wedding->guest_title); ?></h3>
                        <p>
                           <?php echo $wedding->guest_description; ?>

                        </p>
                    </div>
                </div>
                <div class="col-lg-5 col-md-6 col-sm-12">
                    <div class="wedding-img">
                        <img src="<?php echo e(asset("storage/$wedding->guest_image")); ?>" class="img-fluid rounded" alt="">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-5 px-0">
                    <img src="<?php echo e(asset("storage/$wedding->advantage_image")); ?>" class="img-fluid" alt="">
                </div>
                <div class="col-lg-7">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="planning-cont">
                                <h3 class="mt-4"><?php echo e($wedding->advantage_title); ?></span> </h3>
                                <p>
                                    <?php echo $wedding->advantage_description; ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/wwwgilltravel/public_html/resources/views/Frontend/Pages/Wedding/wedding.blade.php ENDPATH**/ ?>