@extends('Frontend.layout.master')

@section('title')
    <title>{{ $content->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $content->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $content->meta_keywords }}">
@endsection

@section('page-contents')
    <section class="breadcrum" style="background-image: url({{ asset("storage/$content->banner") }}); ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1> Destinations for you</h1>
                </div>
            </div>
        </div>
    </section>
    <div class="tour-wrap ptb">
        <div class="container">
            <div class="row">
                @foreach ($destinations as $destination)
                    <div class="col-lg-6">
                        <div class="tab_destinations_boxed">
                            <div class="tab_destinations_img">
                                <a href="#" class="">
                                    <img src="{{ asset("storage/$destination->image") }}" alt="img">
                                </a>
                            </div>
                            <div class="tab_destinations_conntent">
                                <h3>{{ $destination->package_name }}</h3>
                                {!! $destination->package_details !!}
                            </div>
                            <div class="price-tab text-center">
                                <div class="price">
                                    <h3>${{ $destination->price }}</h3>
                                    <p>{{ $destination->price_note }}</p>
                                </div>
                                <div class="book">
                                    <a href="{{ route('booking-pacakage-forms', $destination->id) }}"
                                        style="text-decoration:none">
                                        <h6>BOOK</h6>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection
