@extends('Frontend.layout.master')

@section('title')
    <title>{{ $group_vacation->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="description" content="{{ $group_vacation->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="keywords" content="{{ $group_vacation->meta_keywords }}">
@endsection

@section('page-contents')
    <section class="breadcrum"
        style="background-image: url({{ asset("storage/$group_vacation->banner") }}); background-position: bottom center; ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>{{ $group_vacation->title }}</h1>
                </div>
            </div>
        </div>
    </section>

    <section class="book-view">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 my-auto">
                    <h2 class="text-white">Discover, explore, and book your next adventure with us today !</h2>
                </div>
                <div class="col-lg-4 my-auto ms-auto">
                    <a href="{{ route('booking-forms', ['page_name' => $group_vacation->title]) }}" class="text-decoration-none">
                        <button class="book-now">
                            <span class="text">Book with us</span>
                            <span class="icon"><svg aria-hidden="true" width="20px" data-icon="paper-plane"
                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512">
                                    <path fill="currentColor"
                                        d="M476 3.2L12.5 270.6c-18.1 10.4-15.8 35.6 2.2 43.2L121 358.4l287.3-253.2c5.5-4.9 13.3 2.6 8.6 8.3L176 407v80.5c0 23.6 28.5 32.9 42.5 15.8L282 426l124.6 52.2c14.2 6 30.4-2.9 33-18.2l72-432C515 7.8 493.3-6.8 476 3.2z">
                                    </path>
                                </svg></span>
                        </button>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="ptb group-section bg-light">
        <div class="container">
            <div class="row">

                <div class="mb-5">
                    <a href={{ route('index') }} class="back-button">Back to home <i class="fa fa-arrow-left"></i></a>
                </div>

                <div class="col-lg-5 mx-auto col-md-6 col-sm-12">
                    <img src="{{ asset("storage/$group_vacation->image") }}" class="img-fluid" alt="">
                </div>
                <div class="col-lg-5 col-md-6 m-auto col-sm-12">
                    <div class="content">
                        <h1 class="mb-4">{{ $group_vacation->title }}</h1>
                        {!! $group_vacation->description !!}
                    </div>
                </div>
            </div>
        </div>
    </section>



    <section id="holiday_destinations" class="ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="holiday_left_heading">
                        <div class="heading_left_area">
                            <h1 class="group-title">Among our most popular <span class="text-primary">locations
                                    are:</span></h1>
                        </div>
                    </div>
                    <div class="holiday_small_boxed"><a href="#" class=""><img
                                src="{{ asset("storage/$group_vacation->location_image_1") }}" class="img-fluid"
                                alt="img">
                            <div class="holiday_small_box_content">
                                <div class="holiday_inner_content">
                                    <h5>{{ $group_vacation->location_title_1 }}</h5>
                                </div>
                            </div>
                        </a></div>
                </div>
                <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                                            <div class="holiday_small_boxed"><a href="#" class=""><img
                                                        src="{{ asset("storage/$group_vacation->location_image_2") }}"
                                                        alt="img">
                                                    <div class="holiday_small_box_content">
                                                        <div class="holiday_inner_content">
                                                            <h4>{{ $group_vacation->location_title_2 }}</h4>
                                                        </div>
                                                    </div>
                                                </a></div>
                                        </div>
                                        <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                                            <div class="holiday_small_boxed"><a href="#" class=""><img
                                                        src="{{ asset("storage/$group_vacation->location_image_3") }}"
                                                        alt="img">
                                                    <div class="holiday_small_box_content">
                                                        <div class="holiday_inner_content">
                                                            <h4>{{ $group_vacation->location_title_3 }}</h4>
                                                        </div>
                                                    </div>
                                                </a></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                                            <div class="holiday_small_boxed"><a href="#"
                                                    class=""><img
                                                        src="{{ asset("storage/$group_vacation->location_image_4") }}"
                                                        alt="img">
                                                    <div class="holiday_small_box_content">
                                                        <div class="holiday_inner_content">
                                                            <h4>{{ $group_vacation->location_title_4 }}</h4>
                                                        </div>
                                                    </div>
                                                </a></div>
                                        </div>
                                        <div class="col-lg-6 col-md-12 col-sm-12 col-12">
                                            <div class="holiday_small_boxed"><a href="#"
                                                    class=""><img
                                                        src="{{ asset("storage/$group_vacation->location_image_5") }}"
                                                        alt="img">
                                                    <div class="holiday_small_box_content">
                                                        <div class="holiday_inner_content">
                                                            <h4>{{ $group_vacation->location_title_5 }}</h4>
                                                        </div>
                                                    </div>
                                                </a></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>





    <section class="planning-bg" style="background-image: url({{ asset("storage/$group_vacation->about_us_image") }});">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto col-md-12 col-sm-12">
                    {!! $group_vacation->about_us_description !!}
                </div>
            </div>
        </div>
    </section>


    <section class="ptb faq-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2>Group Travel FAQS</h2>
                    </div>
                </div>
                <div class="col-lg-10 mx-auto col-md-12 col-sm-12">
                    {!! $group_vacation->faq !!}
                </div>
            </div>
        </div>
    </section>
@endsection


