@extends('Frontend.layout.master')

@section('page-contents')
    @push('scripts')
        <style>
            .form-section input[type="text"] {
                width: 100%;
                border: 2px solid #124f91;
                border-radius: 4px;
                margin: 8px 0;
                outline: none;
                height: 50px;
                box-sizing: border-box;
                transition: 0.3s;
            }

            .form-section .inputWithIcon input[type="text"] {
                padding-left: 60px;
            }

            .form-section .inputWithIcon {
                position: relative;
            }

            .form-section .inputWithIcon i {
                position: absolute;
                left: 0;
                top: 8px;
                color: #fff;
                transition: 0.3s;
            }

            .form-section .inputWithIcon.inputIconBg i {
                background-color: #124f91;
                color: #fff;
                /* padding: 9px 4px; */
                height: 50px;
                font-size: 18px;
                width: 50px;
                line-height: 50px;
                border-radius: 4px 0 0 4px;
            }
        </style>
    @endpush
    <section class="breadcrum" style="background-image: url('{{ asset('Frontend/img/bookwithus/Book-With-Us.jpg') }}');">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>Book With me</h1>
                    <h5 class="text-white">Travel Agent : {{ $travelagent->name }}</h5>
                    <h5 class="text-white">Travel email : {{ $travelagent->email }}</h5>
                </div>
            </div>
        </div>
    </section>
    <section class="form-section ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form action="{{ route('booking-forms-submit') }}" method="POST">
                        @csrf
                        <div>
                            <div class="row  p-5">

                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <select name="location" id="location">
                                                <option value="">Select Location</option>
                                                @foreach ($locations as $location)
                                                    <option value="{{ route('location_detail', $location->slug) }}">
                                                        {{ $location->title }} </option>
                                                @endforeach
                        
                                            </select>
                                            <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                        {{-- <select name="location" id="location">
                                            <option value="">Select Location</option>
                                            @foreach ($locations as $location)
                                                <option value="{{ route('location_detail', $location->slug) }}">
                                                    {{ $location->title }} </option>
                                            @endforeach
                    
                                        </select> --}}
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="First name" name="first_name">
                                            <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Last name" name="last_name">
                                            <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Email" name="email">
                                            <i class="fa fa-envelope fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Telephone" name="phone_number">
                                            <i class="fa fa-phone fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <select name="service_type" id="service_type">
                                                <option value="">Service type</option>
                                                <option value="Flight" id="flight">
                                                    Flight </option>
                                                <option value="Package" id="package">
                                                    Package </option>
                                                <option value="Cruise" id="cruise">
                                                    Cruise </option>
                                                <option value="Destination Wedding" id="destination_wedding">
                                                    Destination Wedding </option>
                                                <option value="Others" id="others">
                                                    Others </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <label class="mt-2 mb-2">Travel Information</label>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Travel from" name="travelling_from">
                                            <i class="fas fa-plane-departure fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Travel to" name="travelling_to">
                                            <i class="fas fa-plane-arrival fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 pt-2">
                                        <label for="">From date</label>

                                        <div class="inputWithIcon inputIconBg">
                                            <input type="date" placeholder="Preferred Date" name="from_date">
                                            <i class="fa fa-calendar-check-o fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 pt-2">
                                        <label for="">To date</label>
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="date" placeholder="Preferred Date" name="to_date">
                                            <i class="fa fa-calendar-check-o fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Number of people" name="no_of_adults">
                                            <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Number of kids" name="no_of_kids">
                                            <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <input type="text" placeholder="Number of infants" name="no_of_infants">
                                            <i class="fa fa-user fa-lg fa-fw" aria-hidden="true"></i>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 mt-4">
                                        <div class="pt-1">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="1"
                                                    name="direct_flight" id="flexCheckDefault">

                                                <label class="form-check-label" for="flexCheckDefault">
                                                    Direct Flights Only
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mt-4 ">
                                        <div class="Journey_date">
                                            <div class="form-check form-check-inline pt-1">
                                                <input class="form-check-input" type="radio" name="trip_type"
                                                    id="inlineRadio1" value="Round trip">
                                                <label class="form-check-label" for="Round trip">Round
                                                    Trip</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="trip_type"
                                                    id="inlineRadio2"
                                                    value="Multiple
                                                Destinations">
                                                <label class="form-check-label" for="Multiple destinations">Multiple
                                                    Destinations</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 pt-4">
                                        <div class="inputWithIcon inputIconBg">
                                            <textarea type="text" placeholder="Message" name="message" rows="5"></textarea>
                                            {{-- <i class="fa fa-comments fa-lg fa-fw" aria-hidden="true"></i> --}}
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 text-center mt-4 col-sm-12">
                                    <button class="button2" type="submit" name="dfgfshdhdf"><span>Submit</span></button>
                                </div>

                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script>
        $('.book').on('change', function() {
            var $this = $(this);
            var id = $this.attr("id");
            // alert(id);
            var count = $(this).val();
            for (i = 0; i < count; i++) {
                let details = $('#details');
                details.append(`
                <div class="row item mt-2">
                                <input type="hidden" name="type[]" value=${id}>
                                <div class="col-lg-3"></div>
                                <div class="form-group col-lg-4" >
                                    <label for="Name" class="form-check-label text-white">Name<span style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="name" name="names[]"
                                        placeholder="Name" required>
                                    @error('name')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="Age" class="form-check-label text-white">Age<span style="color: red">*</span></label>
                                    <input type="number" class="form-control" id="age" name="age[]"
                                        placeholder="Age" required>
                                    @error('age')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div> 
                                <div class="col-lg-1 my-auto">
                            <button type="button" class="btn btn-danger remove mt-4">X</button>
                            </div>
                        </div>
                        `);
            }
        });

        $(document).on("click", ".remove", function(event) {
            alert('Are you sure?');
            $(this).parent().closest(".item").remove();
        });
    </script>
@endpush
