@extends('Frontend.layout.master')

{{-- @section('title')
    <title>{{ $link->meta_title }}</title>
@endsection
@section('meta_description')
    <meta name="meta_description" content="{{ $link->meta_description }}">
@endsection
@section('meta_keywords')
    <meta name="meta_keywords" content="{{ $link->meta_keywords }}">
@endsection --}}

@section('page-contents')
    <section class="breadcrum" style="background-image: url({{ asset("storage/$destination_link_content->banner") }}); ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <h1>{{ $destination_link_content->title }} Travel Guide</h1>
                </div>
            </div>
        </div>
    </section>
    <section class="ptb">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6 my-auto col-sm-12">
                    <div class="content px-4">
                        <h1 class="mb-4">{{ $destination_link_content->destination_name }} </h1>
                        <p>
                            {!! $destination_link_content->destination_description !!}
                        </p>
                    </div>
                </div>
                <div class="col-lg-5 mx-auto col-md-6 col-sm-12">
                    <img src="{{ asset("storage/$destination_link_content->destination_image") }}" class="img-fluid rounded"
                        alt="">
                </div>
            </div>
        </div>
    </section>

    <div class="post-two-area">
        <div class="container">

            <div class="row justify-content-center">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2>Before Travelling to {{ $destination_link_content->title }} </h2>
                    </div>
                </div>

                @foreach ($destination_link_content->destinations as $item)
                    @php
                        $destination_guide = \App\Models\DestinationGuide::find($item->id);
                        // dd($destination_guide);
                    @endphp

                    <div class="col-lg-10">
                        <div class="post-list">
                            <div class="single-post">
                                <div class="inner-post">
                                    <div class="row d-flex">
                                        <div class="col-lg-4">
                                            <div class="post-img">
                                                <a href="#"><img
                                                        src="{{ asset("storage/$destination_guide->image") }}"
                                                        class="img-fluid" alt="blog"></a>
                                            </div>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="post-info">
                                                <div class="post-title">
                                                    <h3><a href="#">{{ $destination_guide->title }}</a></h3>
                                                </div>
                                                <div class="post-content">
                                                    <p>
                                                        {!! $destination_guide->description !!}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <section class="detail-exp ptb" style="background-color: rgb(242, 255, 242)">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 col-md-12 mb-5 col-sm-12 col-12">
                    <div class="section_heading_center">
                        <h2>Experiencing {{ $destination_link_content->title }}</h2>
                    </div>
                </div>
                @foreach ($destination_link_content->destinations_experience as $item)
                    @php
                        $destinations_experience_content = \App\Models\DestinationExperience::find($item->id);
                        // dd($destinations_experience_content);
                    @endphp
                    <div class="col-lg-10 col-md-12 col-sm-12 mx-auto exp-card">
                        <div class="row">
                            <div class="col-lg-4 col-lg-4 col-sm-12">
                                <div class="img-icon">
                                    <img src="{{asset("storage/$destinations_experience_content->image")}}" alt="">
                                </div>
                            </div>
                            <div class="col-lg-8 col-md-8 col-sm-12">
                                <h3>{{ $destinations_experience_content->title }}</h3>
                                <p>
                                    {!! $destinations_experience_content->description !!}
                                </p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection
