@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Service Option</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data" action={{ route('admin.service-option.edit', $option->id) }}>
                @csrf
                {{-- image title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Service Option
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body row">
                            <div class="form-group col-md-6">
                                <label for="Title">Type<span style="color: red">*</span></label>
                                <select name="service_type" class="form-select">
                                    <option value="">Select</option>
                                    <option {{ $option->service_type == 'Vacation' ? 'selected' : '' }}>Vacation</option>
                                    <option {{ $option->service_type == 'Cruise Vacation' ? 'selected' : '' }}>
                                        Cruise Vacation
                                    </option>
                                    <option {{ $option->service_type == 'Wedding' ? 'selected' : '' }}>Wedding</option>
                                    <option {{ $option->service_type == 'Wedding Service' ? 'selected' : '' }}>
                                        Wedding Service
                                    </option>
                                </select>
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group col-md-6">
                                <label for="option">Title<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="option" value="{{ $option->option }}"
                                    name="option" placeholder="Title">
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
