@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Travel Professionals</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data"
                action={{ route('admin.travel-professionals.update', $details->id) }}>
                @method('PUT')
                @csrf
                {{-- image title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Travel Professional's Details
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="LocationName">Location<span style="color: red">*</span></label>
                                <select name="location_id" class="form-control">
                                    <option value="">Select</option>
                                    @foreach ($locations as $location)
                                        <option value="{{ $location->id }}"
                                            @if ($location->id == $details->location_id) selected @endif id="{{ $location->id }}">
                                            {{ $location->title }} </option>
                                    @endforeach
                                </select>
                                @error('location_id')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Name">Name<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="name" name="name"
                                    value="{{ $details->name }}">
                                @error('name')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Slug">Slug<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="slug" name="slug"
                                    value="{{ $details->slug }}">
                                @error('slug')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="Phone">Phone</label>
                                <input type="number" class="form-control" id="phone" name="phone"
                                    value="{{ $details->phone }}">
                                @error('phone')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Email">Email<span style="color: red">*</span></label>
                                <input type="email" class="form-control" id="email" name="email"
                                    value="{{ $details->email }}">
                                @error('email')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="Location">Location</label>
                                <input type="text" class="form-control" id="location" name="location"
                                    value="{{ $details->location }}">
                                @error('location')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Languages known">Languages known</label>
                                <input type="text" class="form-control" id="languages_known" name="languages_known"
                                    value="{{ $details->languages_known }}">
                                @error('languages_known')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Profession">Profession</label>
                                <input type="text" class="form-control" id="profession" name="profession"
                                    value="{{ $details->profession }}">
                                @error('profession')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Experience">Experience</label>
                                <input type="text" class="form-control" id="experience" name="experience"
                                    value="{{ $details->experience }}">
                                @error('experience')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Image">Image</label>
                                <input type="file" class="form-control" id="image" name="image"
                                    placeholder="Image">
                                @error('image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <div class="image-section">
                                    <div class="image"> <img src="{{ asset("storage/$details->image") }}"
                                            height="50px">
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="Status">Status<span style="color: red">*</span></label>
                                <select name="status" class="form-control">
                                    <option value="{{ $details->status }}">{{ $details->status ? 'Active' : 'Inactive' }}
                                    </option>
                                    <option value="0" id="inactive">
                                        Inactive </option>
                                    <option value="1" id="active">
                                        Active </option>
                                </select>
                                @error('status')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">

                                <label for="No Quote Request">No Quote Request &nbsp;</label>

                                <input type="checkbox" id="no_quote_request" name="no_quote_request" value="1"
                                    @if ($details->no_quote_request) checked @endif>

                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
