@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Newsletter Subscriptions </h1>
    </div>
    <form action="" method="GET" style="padding: 0px">
        <div class="row">
            <div class="col-lg-2">
                <input type="text" class="form-control" name="search" placeholder="Search">
            </div>

            <div class="col-lg-2">
                <input type="submit" class="btnSearch" value="Search">
            </div>

            <div class="col-lg-2 ml-auto">
                <a href="{{ 'newsletter-export' }}" class="btnSearch"><i
                        class="fas fa-download fa-sm text-white-50"></i>
                    Download</a>
            </div>
        </div>


    </form>
    <div class="row">
        <div class="table-detail">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Email</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($newsletters as $index => $newsletter)
                        <tr>
                            <th scope="row">{{ $newsletters->firstItem() + $index }}</th>
                            <td>{{ $newsletter->email }}</td>
                            <td>
                                @role('Super Admin')
                                    <a class="deleteRecord" data-id="form-submit-{{ $newsletter->id }}"
                                        data-route="{{ route('admin.newsletter.destroy', $newsletter->id) }}">
                                        <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                    </a>
                                    <form method="POST" id="form-submit-{{ $newsletter->id }}"
                                        action="{{ route('admin.newsletter.destroy', $newsletter->id) }}" hidden>
                                        @method('DELETE')
                                        @csrf
                                        <button type="submit"><i class="fas fa-trash"></i></button>
                                    </form>
                                @endrole
                            </td>
                        </tr>
                    @endforeach
                    @if (session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                    @endif
                </tbody>
            </table>
            {{ $newsletters->links('pagination::bootstrap-4') }}
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
@endpush
