@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Locations</h1>
    </div>
    <div>
        <a class="btn btn-danger btn-sm" href="{{ route('admin.location.create') }}">
            Add
        </a>
    </div>
    <x-session />
    <div class="table-detail">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Name</th>
                    <th scope="col">Position</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($locations as $index => $location)
                    <tr>
                        <th scope="row">{{ $locations->firstItem() + $index }}</th>
                        <td>{{ $location->title }}</td>

                        <td>{{ $location->position }}</td>
                        <td>
                            <a href="{{ route('admin.location.edit', $location->id) }}">
                                <i class="fas fa-edit"></i>
                            </a>
                            @role('Super Admin')
                                <a class="deleteRecord" data-id="form-submit-{{ $location->id }}"
                                    data-route="{{ route('admin.location.destroy', $location->id) }}">
                                    <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                </a>
                                <form method="POST" id="form-submit-{{ $location->id }}"
                                    action="{{ route('admin.location.destroy', $location->id) }}" hidden>
                                    @method('DELETE')
                                    @csrf
                                    <button type="submit"><i class="fas fa-trash"></i></button>
                                </form>
                            @endrole
                        </td>
                    </tr>
                @endforeach
                @if (session()->has('message'))
                    <div class="alert alert-success">
                        {{ session()->get('message') }}
                    </div>
                @endif
            </tbody>
        </table>
        {{ $locations->links('pagination::bootstrap-4') }}
    </div>
@endsection

@push('scripts')
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
@endpush
