@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Indian Tourism Query</h1>
        {{-- <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                            class="fas fa-download fa-sm text-white-50"></i> Generate Report</a> --}}
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form>
                @method('POST')
                @csrf
                <div class="form-group">
                    <label for="Title">Name<span style="color: red">*</span></label>
                    <input type="text" class="form-control slug" id="title" name="title" value="{{ $query->first_name }} {{ $query->last_name }}"
                        readonly>
                </div>
                <div class="form-group">
                    <label for="Slug">Email<span style="color: red">*</span></label>
                    <input type="text" class="form-control" id="slug" name="slug" value="{{ $query->email }}"
                        readonly>
                </div>
                <div class="form-group">
                    <label for="banner">Phone Number<span style="color: red">*</span></label>
                    <input type="text" class="form-control" id="banner" name="banner" value="{{ $query->phone }}"
                        readonly>
                </div>
                <div class="form-group">
                    <label for="description">Description<span style="color: red">*</span></label>
                    <textarea type="text" class="form-control" rows="8"
                        readonly>{{ $query->message }}</textarea>
                    
                </div>             
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
