@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Home Page Destinations For You Content</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data"
                action={{ route('admin.home-destination-for-you.update', $content->id) }}>
                @method('PATCH')
                @csrf
                {{-- image title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Location
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="LocationName">Location<span style="color: red">*</span></label>
                                <select name="location_id" class="form-control">
                                    <option value="">Select</option>
                                    @foreach ($locations as $location)
                                        <option value="{{ $location->id }}"
                                            @if ($location->id == $content->location_id) selected @endif id="{{ $location->id }}">
                                            {{ $location->location_name }} </option>
                                    @endforeach
                                </select>
                                @error('location_id')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Package Name">Package Name<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="package_name" name="package_name"
                                    value="{{ $content->package_name }}">
                                @error('package_name')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Package Details">Package Details<span style="color: red">*</span></label>
                                <input type="text" class="form-control slug" id="package_details" name="package_details"
                                    value="{{ $content->package_details }}">
                                @error('package_details')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Price">Price<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="price" name="price"
                                    value="{{ $content->price }}">
                                @error('price')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Price Note">Price Note<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="price_note" name="price_note"
                                    value="{{ $content->price_note }}">
                                @error('price_note')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Image">Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="image"
                                    placeholder="Image">
                                @error('image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="phone_number-section">
                                        <div class="phone_number"> <img src="{{ asset("storage/$content->image") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="form-group">
                                <label for="Image">Image 1<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="image1" placeholder="Image"
                                    accept="image/*">

                                @error('image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->image1") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                            <div class="form-group">
                                <label for="Image">Image 2</label>
                                <input type="file" class="form-control" id="image" name="image2" placeholder="Image"
                                    accept="image/*">

                                @error('image2')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->image2") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="form-group">
                                <label for="Pdf">Pdf<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="pdf" name="pdf"
                                    placeholder="Pdf">

                                @error('pdf')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <embed src="{{ asset("storage/$content->pdf") }}"
                                                width="800px" height="200px" /></div>
                                    </div>
                                </div>
                            @endif
                            <div class="form-group">
                                <label for="PDF">Position</label>
                                <input type="number" class="form-control" value="{{ $content->position }}"
                                    name="position" placeholder="Position">
                                @error('position')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="Status">Status<span style="color: red">*</span></label>
                                <select name="status" class="form-control">
                                    <option value="{{ $content->status }}">{{ $content->status ? 'Active' : 'Inactive' }}
                                    </option>
                                    <option value="0" id="inactive">
                                        Inactive </option>
                                    <option value="1" id="active">
                                        Active </option>
                                </select>
                                @error('status')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
@endpush
