@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Goup Vacation Content</h1>
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" enctype="multipart/form-data"
                action=@if ($content) {{ route('admin.group-vacation.update', $content->id) }}  @else {{ route('admin.group-vacation.store') }} @endif>
                @if ($content)
                    @method('PATCH')
                @endif
                @csrf
                {{-- Banner title --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Title|Banner
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="title" name="title" placeholder="Title"
                                    value="{{ $content ? $content->title : '' }}">
                                @error('title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Banner">Banner<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="banner" name="banner"
                                    placeholder="Banner" accept="image/*">

                                @error('banner')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->banner") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                {{-- Header --}}
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Header
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Description">Description<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="description" name="description"
                                    placeholder="Description"
                                    value="{{ $content ? $content->description : '' }}">
                                @error('description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Header Image">Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="image" name="image"
                                    placeholder="Header Image 1" accept="image/*">
                                @error('image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->image") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Group Travel locations
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 1<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_1" name="location_title_1"
                                    placeholder="Title 1"
                                    value="{{ $content ? $content->location_title_1 : '' }}">
                                @error('location_title_1')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 1<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_1" name="location_image_1"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_1')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_1") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 2<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_2" name="location_title_2"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_2 : '' }}">
                                @error('location_title_2')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 2<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_2" name="location_image_2"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_2')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_2") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 3<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_3" name="location_title_3"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_3 : '' }}">
                                @error('location_title_3')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 3<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_3" name="location_image_3"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_3')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_3") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 4<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_4" name="location_title_4"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_4 : '' }}">
                                @error('location_title_4')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 4<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_4" name="location_image_4"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_4')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_4") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 5<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_5" name="location_title_5"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_5 : '' }}">
                                @error('location_title_5')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 5<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_5" name="location_image_5"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_5')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_5") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 6<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_6" name="location_title_6"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_6 : '' }}">
                                @error('location_title_6')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 6<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_6" name="location_image_6"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_6')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_6") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 7<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_7" name="location_title_7"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_7 : '' }}">
                                @error('location_title_7')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 7<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_7" name="location_image_7"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_7')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_7") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Title">Title 8<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="location_title_8" name="location_title_8"
                                    placeholder="Title"
                                    value="{{ $content ? $content->location_title_8 : '' }}">
                                @error('location_title_8')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Location Image">Location Image 8<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="location_image_8" name="location_image_8"
                                    placeholder="Location Image" accept="image/*">
                                @error('location_image_8')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->location_image_8") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            About Us
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Description">Description<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="about_us_description" name="about_us_description"
                                    placeholder="About Us Description"
                                    value="{{ $content ? $content->description : '' }}">
                                @error('about_us_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Header Image">Image<span style="color: red">*</span></label>
                                <input type="file" class="form-control" id="about_us_image" name="about_us_image"
                                    placeholder="About Us Image" accept="image/*">
                                @error('about_us_image')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            @if ($content)
                                <div class="form-group">
                                    <div class="image-section">
                                        <div class="image"> <img src="{{ asset("storage/$content->about_us_image") }}"
                                                height="50px">
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Group Travel Faqs
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Group Travel Faqs">Group Travel Faqs<span style="color: red">*</span></label>
                                <input type="text" class="form-control" id="faq" name="faq"
                                    placeholder="Group Travel Faqs"
                                    value="{{ $content ? $content->faq : '' }}">
                                @error('faq')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>

                 {{-- Meta details  --}}
                 <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            Meta details
                        </button>
                    </h2>
                    <div id="collapseSeven" class="accordion-collapse collapse show" aria-labelledby="headingSeven">
                        <div class="accordion-body">
                            <div class="form-group">
                                <label for="Meta title">Meta title<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="meta_title" name="meta_title">{{ $content ? $content->meta_title : '' }}</textarea>
                                @error('meta_title')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="Meta Description">Meta Description<span style="color: red">*</span></label>
                                <textarea class="form-control" rows="8" id="meta_description" name="meta_description"
                                    placeholder="Meta Description">{{ $content ? $content->meta_description : '' }}</textarea>
                                @error('meta_description')
                                    <span class="error">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <div class="form-group">
                                    <label for="Meta Keywords">Meta Keywords<span style="color: red">*</span></label>
                                    <textarea class="form-control" rows="8" id="meta_keywords" name="meta_keywords" placeholder="Meta Keywords">{{ $content ? $content->meta_keywords : '' }}</textarea>
                                    @error('meta_keywords')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
