@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Add Top Cruise Ports</h1>
        {{-- <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"><i
                            class="fas fa-download fa-sm text-white-50"></i> Generate Report</a> --}}
    </div>
    <div class="row">
        <div class="col-lg-12 mx-auto">
            <form method="POST" action="{{ route('admin.top-cruise-ports.store') }}" enctype="multipart/form-data">
                @method('POST')
                @csrf
                
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                           Ports
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo">
                        <div class="accordion-body">
                            <div id="guide_list">
                                <div class="form-group">
                                    <label for="Port Name">Port Name<span style="color: red">*</span></label>
                                    <input type="text" class="form-control slug" id="port_name" name="port_name"
                                        placeholder="Port Name">
                                    @error('port_name')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="Title">Title<span style="color: red">*</span></label>
                                    <input type="text" class="form-control slug" id="title" name="guide_title[]"
                                        placeholder="Title">
                                    @error('title')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="image">Image<span style="color: red">*</span></label>
                                    <input type="file" class="form-control" id="image" name="guide_image[]"
                                        placeholder="Image" accept="image/*">
                                    @error('image')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="description">Description<span style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="description"
                                        name="guide_description[]" placeholder="Description">
                                    @error('description')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-danger btn-sm" id="add_destination_guide">+ Add
                            </button>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </form>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        $('.slug').on('change', function() {
            var val = $(this).val();
            var slug = val.replace(/\s+/g, "-");
            $('#slug').val(slug.toLowerCase());
        });
    </script>
    <script>
        $(document).on("click", "#add_destination_guide", function(event) {
            let guide_list = $('#guide_list');
            let guide_item = $('.guide_item').length;
            guide_list.append(`
            <div>
                                <div class="form-group">
                                    <label for="Title">Title<span style="color: red">*</span></label>
                                    <input type="text" class="form-control slug" id="title" name="guide_title[]"
                                        placeholder="Title">
                                    @error('title')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="image">Image<span style="color: red">*</span></label>
                                    <input type="file" class="form-control" id="image" name="guide_image[]"
                                        placeholder="Image" accept="image/*">
                                    @error('image')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="description">Description<span style="color: red">*</span></label>
                                    <input type="text" class="form-control" id="description" name="guide_description[]"
                                        placeholder="Description">
                                    @error('description')
                                        <span class="error">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

    `);

        });
    </script>
    <script>
        $(document).on("click", ".experience_item_remove", function(event) {
            $(this).parent().closest(".experience_item").remove();
        });
    </script>
@endpush
