@extends('Admin.layout.master')

@section('page-contents')
    <div>
        <div class="row">
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">Career Inquiry Details </h1>
            </div>
            <div class="col-lg-12 mx-auto">

                <div class="view-detail">
                    <div class="form-group">
                        <label for="Location">Location Name</label>
                        <input type="text" class="form-control" value="{{ $enquiry->location->title }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Title">First Name</label>
                        <input type="text" class="form-control" value="{{ $enquiry->first_name }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Title">Last Name</label>
                        <input type="text" class="form-control" value="{{ $enquiry->last_name }}" readonly>
                    </div>
                   
                    <div class="form-group">
                        <label for="Phone Number">Phone Number</label>
                        <input type="text" class="form-control" value="{{ $enquiry->phone_number }}" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="Email">Email</label>
                        <input type="text" class="form-control" value="{{ $enquiry->email }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Status in Canada</label>
                        <input type="text" class="form-control" value="{{ $enquiry->status_in_canada }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Position</label>
                        <input type="text" class="form-control" value="{{ $enquiry->position }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">City</label>
                        <input type="text" class="form-control" value="{{ $enquiry->city }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Province</label>
                        <input type="text" class="form-control" value="{{ $enquiry->province }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Postal Code</label>
                        <input type="text" class="form-control" value="{{ $enquiry->postal_code }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Resume">Resume</label>
                        <embed src={{ asset("storage/$enquiry->file") }} type="application/pdf" height="300px"
                            width="100%">
                    </div>

                    <div class="form-group">
                        <label for="Message">Message</label>
                        <textarea class="form-control" rows="8" readonly>{{ $enquiry->message }}</textarea>
                    </div>
                </div>

                <a href="{{ route('admin.careers.index') }}">
                    <button class="btn btn-sm btn-info">
                        <i class="fa fa-arrow-left"></i>
                    </button>
                </a>
            </div>
        </div>
    </div>
@endsection
