@extends('Admin.layout.master')

@section('page-contents')
    <div>
        <div class="row">
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">Book With Us Inquiry Details </h1>
            </div>
            <div class="col-lg-12 mx-auto">

                <div class="view-detail">
                    <div class="form-group">
                        <label for="Title">Location Name</label>
                        <input type="text" class="form-control" value="{{ $inquiry->location->title }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Title">Page Name</label>
                        <input type="text" class="form-control" value="{{ $inquiry->page_name }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Title">First Name</label>
                        <input type="text" class="form-control" value="{{ $inquiry->first_name }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Title">Last Name</label>
                        <input type="text" class="form-control" value="{{ $inquiry->last_name }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Email</label>
                        <input type="text" class="form-control" value="{{ $inquiry->email }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Phone Number">Phone Number</label>
                        <input type="text" class="form-control" value="{{ $inquiry->phone_number }}" readonly>
                    </div>


                    <div class="form-group">
                        <label for="Email">Service Type</label>
                        <input type="text" class="form-control" value="{{ $inquiry->service_type }}" readonly>
                    </div>
                    @if($inquiry->service)
                    <div class="form-group">
                        <label for="Email">Service</label>
                        <input type="text" class="form-control" value="{{ $inquiry->service }}" readonly>
                    </div>
                    @endif
                    @if($inquiry->wedding_service)
                    <div class="form-group">
                        <label for="Email">Wedding Service</label>
                        <input type="text" class="form-control" value="{{ $inquiry->wedding_service }}" readonly>
                    </div>
                    @endif

                    <div class="form-group">
                        <label for="Email">Travelling From</label>
                        <input type="text" class="form-control" value="{{ $inquiry->travelling_from }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Travelling To</label>
                        <input type="text" class="form-control" value="{{ $inquiry->travelling_to }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Number of adults</label>
                        <input type="text" class="form-control" value="{{ $inquiry->no_of_adults }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Number of children</label>
                        <input type="text" class="form-control" value="{{ $inquiry->no_of_kids }}" readonly>
                    </div>
                    <div class="form-group">
                        <label for="Email">Number of infants</label>
                        <input type="text" class="form-control" value="{{ $inquiry->no_of_infants }}" readonly>
                    </div>

                    <div class="form-group">
                        <label for="Message">Comments</label>
                        <textarea class="form-control" rows="8" readonly>{{ $inquiry->comments }}</textarea>
                    </div>
                </div>

                <a href="{{ route('admin.book-with-us-inquiry.index') }}">
                    <button class="btn btn-sm btn-info">
                        <i class="fa fa-arrow-left"></i>
                    </button>
                </a>
            </div>
        </div>
    </div>
@endsection
