@extends('Admin.layout.master')

@section('page-contents')
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Book With Us Inquiry</h1>
    </div>
    <form action="" method="GET" style="padding: 0px">
        <div class="row">

            <div class="col-lg-2">
                <input type="text" class="form-control" name="search" placeholder="Search">
            </div>
            <div class="col-lg-3">
                <select name="location_id" class="form-control" id="location_id" class="c-select">
                    <option value="">Select Location</option>
                    @foreach ($locations as $location)
                        <option value="{{ $location->id }}">
                            {{ $location->title }} </option>
                    @endforeach

                </select>
            </div>
            <div class="col-lg-3">
                <select name="service_type" class="form-control" id="service_type" class="c-select">
                    <option value="">Select Service Type</option>
                    <option value="Flights" id="Flights">
                        Flights </option>
                    <option value="Cruises" id="Cruises">
                        Cruises </option>
                    <option value="Destination Wedding" id="DestinationWedding">
                        Destination Wedding </option>
                    <option value="Vacation" id="Vacation">
                        Vacation </option>
                    <option value="Travel" id="Travel">
                        Travel </option>
                    <option value="Group travel" id="GroupTravel">
                        Group travel </option>

                    <option value="Indian Tourism" id="IndianTourism">
                        Indian Tourism </option>

                    <option value="Others" id="Others">
                        Others </option>

                </select>
            </div>
            <div class="col-lg-2">
                <input type="submit" class="btnSearch" value="Search">
            </div>

            <div class="col-lg-2 ml-auto">
                <a href="{{ 'bookwithus-export' }}" class="btnSearch"><i class="fas fa-download fa-sm text-white-50"></i>
                    Download</a>
            </div>
        </div>
    </form>
    <div class="row">
        <div class="table-detail">
            <table class="table table-hover">

                {{-- {{dd($inquiries)}} --}}
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Location Name</th>
                        <th scope="col">Service type</th>
                        <th scope="col">First Name</th>
                        <th scope="col">Last Name</th>
                        <th scope="col">Phone Number</th>
                        <th scope="col">Email</th>

                        <th scope="col">Action</th>

                    </tr>
                </thead>
                <tbody>
                    @foreach ($inquiries as $index => $inquiry)
                        <tr>
                            <th scope="row">{{ $inquiries->firstItem() + $index }}</th>
                            <td>{{ $inquiry->location->title }}</td>
                            <td>{{ $inquiry->service_type }}</td>
                            <td>{{ $inquiry->first_name }}</td>
                            <td>{{ $inquiry->last_name }}</td>

                            <td>{{ $inquiry->phone_number }}</td>
                            <td>{{ $inquiry->email }}</td>


                            <td>
                                <a href="{{ route('admin.book-with-us-inquiry.show', $inquiry->id) }}">
                                    <i class="fas fa-eye"></i>
                                </a>
                                @role('Super Admin')
                                    <a class="deleteRecord" data-id="form-submit-{{ $inquiry->id }}"
                                        data-route="{{ route('admin.book-with-us-inquiry.destroy', $inquiry->id) }}">
                                        <i class="fas fa-trash" style="color:rgb(255, 23, 23)"></i>
                                    </a>
                                    <form method="POST" id="form-submit-{{ $inquiry->id }}"
                                        action="{{ route('admin.book-with-us-inquiry.destroy', $inquiry->id) }}" hidden>
                                        @method('DELETE')
                                        @csrf
                                        <button type="submit"><i class="fas fa-trash"></i></button>
                                    </form>
                                @endrole


                            </td>
                        </tr>
                    @endforeach
                    @if (session()->has('message'))
                        <div class="alert alert-success">
                            {{ session()->get('message') }}
                        </div>
                    @endif
                </tbody>
            </table>
            {{ $inquiries->links('pagination::bootstrap-4') }}
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            let location = new URLSearchParams(window.location.search).get("location_id");
            let service_type = new URLSearchParams(window.location.search).get("service_type");

            $('#location_id').val(location)
            $('#service_type').val(service_type)
        })
    </script>
    <script>
        $('.deleteRecord').on('click', function() {
            var id = $(this).data('id');
            if (confirm('Are you sure you want to delete this?')) {
                $('#' + id + '').submit();
            }
        })
    </script>
@endpush
