<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fligt_forms', function (Blueprint $table) {
            $table->id();
            $table->foreignId('location_id')->constrained('locations')->onDelete('cascade');
            $table->string('leaving_from');
            $table->string('going_to');
            $table->string('from_date');
            $table->string('to_date');
            $table->string('no_of_adults');
            $table->string('no_of_children');
            $table->string('no_of_infants');
            $table->tinyInteger('direct_flight');
            $table->string('trip_type');
            $table->string('email');
            $table->text('comments');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fligt_forms');
    }
};
