<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('home_destination_for_yous', function (Blueprint $table) {
            $table->id();
            $table->foreignId('location_id')->constrained('home_destination_for_you_locations')->onDelete('cascade');
            $table->string('package_name');
            $table->text('package_details');
            $table->text('image');
            $table->text('image1');
            $table->text('image2');
            $table->string('price');
            $table->string('price_note');
            $table->tinyInteger('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('home_destination_for_yous');
    }
};

      