<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flight_bookings', function (Blueprint $table) {
            $table->id();
            $table->string('leaving_from');
            $table->string('going_to');
            $table->string('from_date');
            $table->string('to_date');
            $table->string('no_of_adults');
            $table->string('no_of_children');
            $table->string('no_of_infants');
            $table->tinyInteger('direct_flight');
            $table->tinyInteger('trip_type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flight_bookings');
    }
};
