<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class IndianTourismMail extends Mailable
{
    public $request,  $file_path;
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($request,  $file_path = null)
    {
        $this->request = $request;
        $this->file_path =  $file_path;
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function build()
    {
        // return $this->subject('Thank you for filling the information, We will get back to you soon!')->view('Frontend.Mail.indianTourismMail');
        if ($this->file_path) {
            return $this->subject('Thank you for filling the information, We will get back to you soon!')
                ->view('Frontend.Mail.indianTourismMail')
                ->attach(public_path('storage/' . $this->file_path));
        } else {
            return $this->subject('Thank you for filling the information, We will get back to you soon!')
            ->view('Frontend.Mail.indianTourismMail');
          
        }
    }
}
