<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class VacationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'title'    =>  'required',
            'banner'  =>  'required|mimes:jpeg,bmp,png',
            'description'  =>  'required',
            'image'     =>  'required|mimes:jpeg,bmp,png',
            'meta_title'  =>  'required',
            'meta_description' =>  'required',
            'meta_keywords' =>  'required' ,
        ];
    }
}
