<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\AllDestination;
use App\Models\Destination;
use App\Models\InformationLink;
use App\Models\UsefulLink;
use Illuminate\Http\Request;

class FooterController extends Controller
{
    public function useful_links()
    {
        $useful_links = UsefulLink::orderBy('position')->get();
        return response()->json($useful_links);
    }
    public function information_links()
    {
        $information_links = InformationLink::orderBy('position')->get();
        return response()->json($information_links);
    }
   
    public function useful_link_pages($slug)
    {
       
        $link = UsefulLink::where('slug', $slug)->first();

        return view('Frontend.FooterPages.UsefulLinks', compact('link'));
    }
    public function information_link_pages($slug)
    {
        
        $link = InformationLink::where('slug', $slug)->first();

        return view('Frontend.FooterPages.InformationLinks', compact('link'));
    }

    public function destinations()
    {
        $destination_link = Destination::all();
        return response()->json($destination_link);
    }

    public function destinations_link_pages($slug)
    {
       
        $destination_link_content = Destination::where('slug', $slug)->first();
        return view('Frontend.FooterPages.DestinationPages', compact('destination_link_content'));
    }

    public function all_destinations()
    {
        $content = AllDestination::first();
        $destinations = Destination::all();
        return view('Frontend.FooterPages.AllDestinations', compact('content','destinations'));
    }

}
