<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Mail\AdminMail;
use App\Mail\FlightBookingMail;
use App\Mail\IndianTourismMail;
use App\Models\AdminMails;
use App\Models\FlightBooking;
use App\Models\FlightBookingInformation;
use App\Models\FligtForm;
use App\Models\Location;
use App\Models\TravelProfessional;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class FlightBookingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $travelagent = TravelProfessional::find($id);
        return view('Frontend.Pages.BookWithMe.bookWithMe', compact('travelagent'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $request->validate([
            'location_id'    => 'required',
            'leaving_from'   => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'going_to'       => ['required', 'regex:/^[a-zA-Z\s]+$/'],
            'from_date'      => 'required|date',
            'to_date'        => 'required|date',
            'no_of_adults'   => 'required|integer|min:1',
            'no_of_children' => 'required|integer|min:0',
            'no_of_infants'  => 'required|integer|min:0',
            'trip_type'      => 'required',
        ], [
            'location_id.required' => 'This field is required',
            'no_of_adults.required' => 'This field is required',
            'no_of_children.required' => 'This field is required',
            'no_of_infants.required' => 'This field is required',
        ]);
        if ($request->faxonly) {
            return redirect()->back()->withSuccess('Your form has been submitted');
        }
        $booking = new FligtForm();
        $booking->location_id = $request->location_id;
        $booking->leaving_from = $request->leaving_from;
        $booking->going_to = $request->going_to;
        $booking->from_date = $request->from_date;
        $booking->to_date = $request->to_date;
        $booking->no_of_adults = $request->no_of_adults;
        $booking->no_of_children = $request->no_of_children;
        $booking->no_of_children = $request->no_of_children;
        $booking->no_of_infants = $request->no_of_infants;
        $booking->comments = $request->comments;
        $booking->direct_flight = $request->direct_flight ?? 0;
        $booking->trip_type = $request->trip_type;
        $booking->email = $request->email;
        $booking->name           = $request->name;
        $booking->phone          = $request->phone;
        $booking->save();



        // $travelagent = TravelProfessional::pluck('email')->where('id', $request->travelagent);
        // Mail::to($travelagent)->send(new FlightBookingMail($booking, $bookinginfo));
        // $bookinginfo = FlightBookingInformation::where('booking_id', $booking->id);

        $country_codes = [
            '780','825','587','403','250','604','236','672','778',
            '431','204','506','428','709','867','902','782','807',
            '905','705','647','613','548','519','437','416','365',
            '343','289','249','226','438','450','514','418','367',
            '819','354','579','873','581','306','639'
        ];
        
        $phone = $request->phone;
        
        // Ensure phone is at least 3 characters long before extracting area code
        if (strlen($phone) >= 3) {
            $phone1 = substr($phone, 0, 3);
        
            if (in_array($phone1, $country_codes)) {
                // Send email to user
                Mail::to($request->email)->send(new IndianTourismMail($request));
        
                // Fetch location and check if it exists
                $location_mail = Location::find($request->location_id);
                if ($location_mail) {
                    // Extract emails and send admin emails
                    $admin = explode(',', str_replace(" ", "", $location_mail->email_cc));
                    $all_emails = array_merge([$location_mail->email], $admin);
                    Mail::to($all_emails)->send(new FlightBookingMail($request));
                }
            }else{
                $booking->delete();
            }
        } 
        return redirect()->back()->with('message', 'FORM SUBMITTED SUCCESSFULLY, THANK YOU!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
