<?php

namespace App\Http\Controllers\Admin\BookWithUsInquiry;

use App\Exports\BookWithUsInquiry;
use App\Http\Controllers\Controller;
use App\Models\FormData;
use App\Models\Location;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class BookWithUsInquiryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $query = FormData::query();
        $location = request()->location_id;
        $service_type = request()->service_type;
        $search = request()->search;

        if ($location && $location != '') {
            $query->where('location_id', $location);
        }

        if ($service_type && $service_type != '') {
            $query->where('service_type', $service_type);
        }

        if ($search && $search != '') {
            $columns = ['phone_number', 'first_name', 'last_name', 'email', 'service_type'];
            foreach ($columns as $column) {
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }

        $locations = Location::all();


        $inquiries = $query->latest()->paginate(10)->appends(request()->query());

        return view('Admin.BookWithUsInquiry.index', compact('locations', 'inquiries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $inquiry = FormData::find($id);

        return view('Admin.BookWithUsInquiry.show', compact('inquiry'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $inquiry = FormData::find($id);

        $inquiry->delete();

        return redirect()->route('admin.book-with-us-inquiry.index');
    }

    public function export()
    {

        
        return Excel::download(new BookWithUsInquiry, 'book-with-us.xlsx');
    }
}
