<?php

namespace App\Http\Controllers\Admin\Newsletter;

use App\Exports\NewsLetterExport;
use App\Http\Controllers\Controller;
use App\Mail\IndianTourismMail;
use App\Mail\NewsLetterAdminMail;
use App\Models\AdminMails;
use App\Models\Newsletter;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Maatwebsite\Excel\Facades\Excel;

class NewsletterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $query = Newsletter::query();

        $search = request()->search;
        if ($search && $search != '') {
            $columns = ['email'];
            foreach ($columns as $column) {
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }
        $newsletters = $query->latest()->paginate(10)->appends(request()->query());

        return view('Admin.NewsLetter.index', compact('newsletters'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'email' => 'required|unique:newsletters,email'
        ]);
        if (!filter_var($request->email, FILTER_VALIDATE_EMAIL)) {
            return redirect()->back()
                ->withSuccess('Your form has been submitted');
        }
        if ($request->faxonly) {
            return redirect()->back()
                ->withSuccess('Your form has been submitted');
        }
        $newsletter = Newsletter::create($request->all());

        Mail::to($request->email)->send(new IndianTourismMail($newsletter));

        //admin mails
        $admin_mails = AdminMails::first();

        if (!is_null($admin_mails) && !is_null($admin_mails->subscription)) {
            $admin = explode(',', str_replace(" ", "", $admin_mails->subscription));
            // Mail::to($admin)->send(new NewsLetterAdminMail($newsletter));
        }

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $newsletter = Newsletter::find($id);

        $newsletter->delete();

        return redirect()->route('admin.newsletter.index');
    }

    public function export()
    {
        return Excel::download(new NewsLetterExport, 'newsletters.xlsx');
    }
}
