<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Models\Location;
use App\Models\Province;
use Illuminate\Http\Request;

class LocationController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $locations = Location::paginate(10);
        return view('Admin.Location.index', compact('locations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $provinces = Province::all();
        return view('Admin.Location.create',compact('provinces'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // dd($request);

        $location = Location::create($request->all());
        return redirect()->route('admin.location.index')->with('success', 'Location added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $provinces = Province::all();
        $location = Location::find($id);
        return view('Admin.Location.edit', compact('location','provinces'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $location = Location::find($id);
        $location->title = $request->title;
        $location->slug = $request->slug;
        $location->address = $request->address;
        $location->phone = $request->phone;
        $location->email = $request->email;
        $location->email_cc = $request->email_cc;
        $location->map_link = $request->map_link;
        $location->lat = $request->lat;
        $location->lng = $request->lng;
        $location->position = $request->position;
        $location->status = $request->status;
        $location->timings = $request->timings;
        $location->province_id = $request->province_id;
        $location->meta_title = $request->meta_title;
        $location->meta_description = $request->meta_description;
        $location->meta_keywords = $request->meta_keywords;
        $location->save();
        return redirect()->route('admin.location.index')->with('success', 'Location updated successfully');;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $location = Location::find($id);
        $location->delete();

        return redirect()->route('admin.location.index');
    }
}
