<?php

namespace App\Http\Controllers\Admin\Home;

use App\Http\Controllers\Controller;
use App\Models\HomeDestinationForYouLocation;
use Illuminate\Http\Request;

class HomeDestinationForYouLocationController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contents = HomeDestinationForYouLocation::paginate(25);
        return view('Admin.HomeDestinationForYouLocation.index', compact('contents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.HomeDestinationForYouLocation.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

       $content = new HomeDestinationForYouLocation();
       $content->location_name = $request->location_name;
       $content->save();

       return redirect()->route('admin.home-destination-for-you-section.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $content = HomeDestinationForYouLocation::find($id);
        return view('Admin.HomeDestinationForYouLocation.edit', compact('content'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $content = HomeDestinationForYouLocation::find($id);
        $content->location_name = $request->location_name;
        $content->save();

        return redirect()->route('admin.home-destination-for-you-section.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $content = HomeDestinationForYouLocation::find($id);
        $content->delete();

        return redirect()->route('admin.home-destination-for-you-section.index');
    }
}
