<?php

namespace App\Http\Controllers\Admin\Home;

use App\Http\Controllers\Controller;
use App\Models\HomeBanner;
use Illuminate\Http\Request;

class HomeBannerController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $banners = HomeBanner::paginate(10);
        return view('Admin.HomeBanner.index', compact('banners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('Admin.HomeBanner.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $banner = $request->file('banner')->store('Home/Banner', 'public');

        $content = new HomeBanner();
        $content->title = $request->title;
        $content->description = $request->description;
        $content->banner = $banner;
        $content->status = $request->status;
        $content->save();

        return redirect()->route('admin.home-banner.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $content = HomeBanner::find($id);
        return view('Admin.HomeBanner.edit', compact('content'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $content = HomeBanner::find($id);
        $content->title = $request->title;
        $content->description = $request->description;
        if ($request->hasFile('banner')) {
            $banner = $request->file('banner')->store('Home/Banner', 'public');
            $content->banner = $banner;
        }
        $content->status = $request->status;
        $content->save();

        return redirect()->route('admin.home-banner.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $content = HomeBanner::find($id);
        $content->delete();

        return redirect()->route('admin.home-banner.index');
    }
}
