<?php

namespace App\Http\Controllers\Admin\GroupVacation;

use App\Http\Controllers\Controller;
use App\Models\GroupVacation;
use Illuminate\Http\Request;

class GroupVacationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $content = GroupVacation::first();
        return view('Admin.GroupVacation.index', compact('content'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);

        $request->validate([
            '*' => 'required',
        ]);

        $banner = $request->file('banner')->store('GroupVacation', 'public');
        $image = $request->file('image')->store('GroupVacation', 'public');
        $location_image_1 = $request->file('location_image_1')->store('GroupVacation', 'public');
        $location_image_2 = $request->file('location_image_2')->store('GroupVacation', 'public');
        $location_image_3 = $request->file('location_image_3')->store('GroupVacation', 'public');
        $location_image_4 = $request->file('location_image_4')->store('GroupVacation', 'public');
        $location_image_5 = $request->file('location_image_5')->store('GroupVacation', 'public');
        $location_image_6 = $request->file('location_image_6')->store('GroupVacation', 'public');
        $location_image_7 = $request->file('location_image_7')->store('GroupVacation', 'public');
        $location_image_8 = $request->file('location_image_8')->store('GroupVacation', 'public');
        $about_us_image = $request->file('about_us_image')->store('GroupVacation', 'public');

        $content = new GroupVacation();
        $content->title = $request->title;
        $content->banner = $banner;
        $content->description = $request->description;
        $content->image = $image;
        $content->location_title_1 = $request->location_title_1;
        $content->location_image_1 = $location_image_1;
        $content->location_title_2 = $request->location_title_2;
        $content->location_image_2 = $location_image_2;
        $content->location_title_3 = $request->location_title_3;
        $content->location_image_3 = $location_image_3;
        $content->location_title_4 = $request->location_title_4;
        $content->location_image_4 = $location_image_4;
        $content->location_title_5 = $request->location_title_5;
        $content->location_image_5 = $location_image_5;
        $content->location_title_6 = $request->location_title_6;
        $content->location_image_6 =  $location_image_6;
        $content->location_title_7 = $request->location_title_7;
        $content->location_image_7 = $location_image_7;
        $content->location_title_8 = $request->location_title_8;
        $content->location_image_8 = $location_image_8;
        $content->about_us_description = $request->about_us_description;
        $content->about_us_image = $about_us_image;
        $content->faq = $request->faq;
        $content->meta_title = $request->meta_title;
        $content->meta_keywords = $request->meta_keywords;
        $content->meta_description = $request->meta_description;
        $content->save();

        return redirect()->route('admin.group-vacation.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request);
        $request->validate([
            '*' => 'required',
        ]);


        $content = GroupVacation::find($id);
        $content->title = $request->title;
        if ($request->hasFile('banner')) {
            $banner = $request->file('banner')->store('GroupVacation', 'public');
            $content->banner = $banner;
        }
        $content->description = $request->description;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('GroupVacation', 'public');
            $content->image = $image;
        }
        $content->location_title_1 = $request->location_title_1;
        if ($request->hasFile('location_image_1')) {
            $location_image_1 = $request->file('location_image_1')->store('GroupVacation', 'public');
            $content->location_image_1 = $location_image_1;
        }
        $content->location_title_2 = $request->location_title_2;
        if ($request->hasFile('location_image_2')) {
            $location_image_2 = $request->file('location_image_2')->store('GroupVacation', 'public');
            $content->location_image_2 = $location_image_2;
        }
        $content->location_title_3 = $request->location_title_3;
        if ($request->hasFile('location_image_3')) {
            $location_image_3 = $request->file('location_image_3')->store('GroupVacation', 'public');
            $content->location_image_3 = $location_image_3;
        }
        $content->location_title_4 = $request->location_title_4;
        if ($request->hasFile('location_image_4')) {
            $location_image_4 = $request->file('location_image_4')->store('GroupVacation', 'public');
            $content->location_image_4 = $location_image_4;
        }
        $content->location_title_5 = $request->location_title_5;
        if ($request->hasFile('location_image_5')) {
            $location_image_5 = $request->file('location_image_5')->store('GroupVacation', 'public');
            $content->location_image_5 = $location_image_5;
        }
        $content->location_title_6 = $request->location_title_6;
        if ($request->hasFile('location_image_6')) {
            $location_image_6 = $request->file('location_image_6')->store('GroupVacation', 'public');
            $content->location_image_6 = $location_image_6;
        }
        $content->location_title_7 = $request->location_title_7;
        if ($request->hasFile('location_image_7')) {
            $location_image_7 = $request->file('location_image_7')->store('GroupVacation', 'public');
            $content->location_image_7 = $location_image_7;
        }
        $content->location_title_8 = $request->location_title_8;
        if ($request->hasFile('location_image_8')) {
            $location_image_8 = $request->file('location_image_8')->store('GroupVacation', 'public');
            $content->location_image_8 = $location_image_8;
        }
        $content->about_us_description = $request->about_us_description;
        if ($request->hasFile('about_us_image')) {
            $about_us_image = $request->file('about_us_image')->store('GroupVacation', 'public');
            $content->about_us_image = $about_us_image;
        }
        $content->faq = $request->faq;
        $content->meta_title = $request->meta_title;
        $content->meta_keywords = $request->meta_keywords;
        $content->meta_description = $request->meta_description;
        $content->save();

        return redirect()->route('admin.group-vacation.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
