<?php

namespace App\Http\Controllers\Admin\ContactAgency;

use App\Exports\ContactAgencyInquiry;
use App\Http\Controllers\Controller;
use App\Models\ContactAgency;
use App\Models\Location;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ContactAgencyController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin'])->only(['destroy']);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $query = ContactAgency::query();

        // $inquires = ContactAgency::paginate(10);
        $location = request()->location_id;
        $search = request()->search;

        if ($location && $location != '') {
            $query->where('location_id', $location);
        }

        if($search && $search != '')
        {
            $columns = ['full_name', 'email', 'phone'];
            foreach($columns as $column){
                $query->orWhere($column, 'LIKE', '%' . $search . '%');
            }
        }

        $inquires = $query->latest()->paginate(10)->appends(request()->query());

        $locations = Location::all();
        return view('Admin.ContactAgencyInquiry.index', compact('inquires', 'locations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $inquiry = ContactAgency::find($id);

        return view('Admin.ContactAgencyInquiry.show', compact('inquiry'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $inquiry = ContactAgency::find($id);

        $inquiry->delete();

        return redirect()->route('admin.contact-agency.index');
    }


    public function export()
    {
        return Excel::download(new ContactAgencyInquiry, 'contact-agency.xlsx');
    }
}
