<?php

namespace App\Http\Controllers\Admin\AdminMails;

use App\Http\Controllers\Controller;
use App\Models\AdminMails;
use Illuminate\Http\Request;

class AdminMailController extends Controller
{
    public function __construct()
    {
        $this->middleware(['role:Super Admin']);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $admin_mails = AdminMails::first();
        return view('Admin.AdminMails.index', compact('admin_mails'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        AdminMails::create($request->all());
        return redirect()->route('admin.admin-mails.index')->with('success', 'Email settings updated successfully');;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        AdminMails::find($id)->update($request->all());
        return redirect()->route('admin.admin-mails.index')->with('success', 'Email settings updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
