<?php

namespace App\Http\Controllers\Admin\AboutUs;

use App\Http\Controllers\Controller;
use App\Http\Requests\AboutUsRequest;
use App\Models\AboutUs;
use Illuminate\Http\Request;

class AboutUsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $content = AboutUs::first();
        return view('Admin.AboutUs.index', compact('content'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(AboutUsRequest $request)
    {
        $banner = $request->file('banner')->store('Aboutus/Banner', 'public');
        $image = $request->file('image')->store('Aboutus/image', 'public');
        $why_choose_us_1_icon = $request->file('why_choose_us_1_icon')->store('Aboutus/why_choose_us_icon', 'public');
        $why_choose_us_2_icon = $request->file('why_choose_us_2_icon')->store('Aboutus/why_choose_us_icon', 'public');
        $why_choose_us_3_icon = $request->file('why_choose_us_3_icon')->store('Aboutus/why_choose_us_icon', 'public');
        $counter_1_icon = $request->file('counter_1_icon')->store('Aboutus/counter_icon', 'public');
        $counter_2_icon = $request->file('counter_2_icon')->store('Aboutus/counter_icon', 'public');
        $counter_3_icon = $request->file('counter_3_icon')->store('Aboutus/counter_icon', 'public');
       
        $content = new AboutUs();
        $content->title = $request->title;
        $content->banner = $banner;

        $content->description = $request->description;
        $content->image = $image;

        $content->why_choose_us = $request->why_choose_us;

        $content->why_choose_us_1_title = $request->why_choose_us_1_title;
        $content->why_choose_us_1_description = $request->why_choose_us_1_description;
        $content->why_choose_us_1_icon = $why_choose_us_1_icon;

        $content->why_choose_us_2_title = $request->why_choose_us_2_title;
        $content->why_choose_us_2_description = $request->why_choose_us_2_description;
        $content->why_choose_us_2_icon = $why_choose_us_2_icon;

        $content->why_choose_us_3_title = $request->why_choose_us_3_title;
        $content->why_choose_us_3_description = $request->why_choose_us_3_description;
        $content->why_choose_us_3_icon = $why_choose_us_3_icon;

        $content->counter_1_title = $request->counter_1_title;
        $content->counter_1_icon = $counter_1_icon ;
        $content->counter_1_count = $request->counter_1_count;

        $content->counter_2_title = $request->counter_2_title;
        $content->counter_2_icon = $counter_2_icon ;
        $content->counter_2_count = $request->counter_2_count;

        $content->counter_3_title = $request->counter_3_title;
        $content->counter_3_icon = $counter_3_icon ;
        $content->counter_3_count = $request->counter_3_count;

        $content->meta_title = $request->meta_title;
        $content->meta_keywords = $request->meta_keywords ;
        $content->meta_description = $request->meta_description;

        $content->save();

        return redirect()->route('admin.about-us.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // $banner = $request->file('banner')->store('Aboutus/Banner', 'public');
        // $image = $request->file('image')->store('Aboutus/image', 'public');
        // $why_choose_us_1_icon = $request->file('why_choose_us_1_icon')->store('Aboutus/why_choose_us_icon', 'public');
        // $why_choose_us_2_icon = $request->file('why_choose_us_2_icon')->store('Aboutus/why_choose_us_icon', 'public');
        // $why_choose_us_3_icon = $request->file('why_choose_us_3_icon')->store('Aboutus/why_choose_us_icon', 'public');
        // $counter_1_icon = $request->file('counter_1_icon')->store('Aboutus/counter_icon', 'public');
        // $counter_2_icon = $request->file('counter_2_icon')->store('Aboutus/counter_icon', 'public');
        // $counter_3_icon = $request->file('counter_3_icon')->store('Aboutus/counter_icon', 'public');
       
        $content =  AboutUs::find($id);
        $content->title = $request->title;
        // $content->banner = $banner;
        if ($request->hasFile('banner')) {
            $banner = $request->file('banner')->store('Aboutus/banner', 'public');
            $content->banner = $banner;
        }

        $content->description = $request->description;
        // $content->image = $image;
        if ($request->hasFile('image')) {
            $image = $request->file('image')->store('Aboutus/image', 'public');
            $content->image = $image;
        }

        $content->why_choose_us = $request->why_choose_us;

        $content->why_choose_us_1_title = $request->why_choose_us_1_title;
        $content->why_choose_us_1_description = $request->why_choose_us_1_description;
        if ($request->hasFile('why_choose_us_1_icon')) {
            $why_choose_us_1_icon = $request->file('why_choose_us_1_icon')->store('Aboutus/why_choose_us_1_icon', 'public');
            $content->why_choose_us_1_icon = $why_choose_us_1_icon;
        }

        $content->why_choose_us_2_title = $request->why_choose_us_2_title;
        $content->why_choose_us_2_description = $request->why_choose_us_2_description;
        if ($request->hasFile('why_choose_us_2_icon')) {
            $why_choose_us_2_icon = $request->file('why_choose_us_2_icon')->store('Aboutus/why_choose_us_2_icon', 'public');
            $content->why_choose_us_2_icon = $why_choose_us_2_icon;
        }

        $content->why_choose_us_3_title = $request->why_choose_us_3_title;
        $content->why_choose_us_3_description = $request->why_choose_us_3_description;
        if ($request->hasFile('why_choose_us_3_icon')) {
            $why_choose_us_3_icon = $request->file('why_choose_us_3_icon')->store('Aboutus/why_choose_us_3_icon', 'public');
            $content->why_choose_us_3_icon = $why_choose_us_3_icon;
        }

        $content->counter_1_title = $request->counter_1_title;
        if ($request->hasFile('counter_1_icon')) {
            $counter_1_icon = $request->file('counter_1_icon')->store('Aboutus/counter_1_icon', 'public');
            $content->counter_1_icon = $counter_1_icon;
        }
        $content->counter_1_count = $request->counter_1_count;

        $content->counter_2_title = $request->counter_2_title;
        if ($request->hasFile('counter_2_icon')) {
            $counter_2_icon = $request->file('counter_2_icon')->store('Aboutus/counter_2_icon', 'public');
            $content->counter_2_icon = $counter_2_icon;
        }
        $content->counter_2_count = $request->counter_2_count;

        $content->counter_3_title = $request->counter_3_title;
        if ($request->hasFile('counter_3_icon')) {
            $counter_3_icon = $request->file('counter_3_icon')->store('Aboutus/counter_3_icon', 'public');
            $content->counter_3_icon = $counter_3_icon;
        }
        $content->counter_3_count = $request->counter_3_count;

        $content->meta_title = $request->meta_title;
        $content->meta_keywords = $request->meta_keywords;
        $content->meta_description = $request->meta_description;

        $content->save();

        return redirect()->route('admin.about-us.index');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
